function t1plotpub(t1data,clev,thresh)
%   t1plot(t1data,clev,thresh);
%   t1plot.m: plots T1/T2 data as obtained from t1_mn.m
%
%   --------------------------------INPUT------------------------------------
%   t1data    =   The data structure from t1_mn
%   clev      =   Number of contour levels
%   thresh    =   Threshold for contour levels as per cent of max peak height
%                 a negative value will set the default value (0.1 1% of
%                 max peak aplitude)
%
%

%
%   Example:
%
%   See also: dosy_mn, score_mn, decra_mn, mcr_mn, varianimport,
%             brukerimport, jeolimport, peakpick_mn, dosyplot_mn,
%             dosyresidual, dosyplot_gui, scoreplot_mn, decraplot_mn,
%             mcrplot_mn
%
%   This is a part of the GNAT
%   Copyright  2017  <Mathias Nilsson>%
%   This program is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   This program is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License along
%   with this program; if not, write to the Free Software Foundation, Inc.,
%   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
%
%   Dr. Mathias Nilsson
%   School of Chemistry, University of Manchester,
%   Oxford Road, Manchester M13 9PL, UK
%   Telephone: +44 (0) 161 306 4465
%   Fax: +44 (0)161 275 4598
% MN     17 August 2017    Making the plot more suitable for publication
% MJS     Edited line 163 'xlabel' to produce delta 1H (1 superscript)



if nargin==0
    disp(' ')
    disp(' ')
    disp('T1/T2 PLOT')
    disp('At least one input is needed')
    disp(' ')
    disp(' Type <<help t1plot>> for more info')
    disp('  ')
    return
end
if nargin >6
    error(' Too many inputs')
end


if nargin>1
    if length(clev)>1
        clvl=clev;
    else
        if clev<=0
            clev=5;
        end
    end
else
    clev=5;
end

if nargin > 2
    if thresh<0
        thresh=0.1;
    end
else
    if isfield(t1data,'threshold')
        thresh=t1data.threshold;
    else
        thresh=0.1;
    end
end
if length(clev)==1
    clvl=2.^(0:clev);
    clvl=clvl(1:clev);
    clvl=1./clvl;
    maxc=max(max(abs(t1data.T1)));
    clvl=clvl.*maxc.*(thresh/100);
end

disp('Plotting relaxation data');

t1Figure = figure('Color',[1 1 1],...
    'NumberTitle','Off',...
    'MenuBar','none',...
    'Toolbar','Figure',...
    'PaperOrientation','Landscape',...
    'PaperType','A4',...
    'Units','centimeters',...
    'Position',[0 0 29.7 21],...
    'Name','ROSY publication plot');
 
%Clean up the Toolbar, removing things we don't need
tmp = findall(t1Figure,'ToolTipString','New Figure');
set(tmp,'Visible','Off')
tmp = findall(t1Figure,'ToolTipString','Edit Plot');
set(tmp,'Visible','Off')
tmp = findall(t1Figure,'ToolTipString','Open File');
set(tmp,'Visible','Off')
tmp = findall(t1Figure,'ToolTipString','Link Plot');
set(tmp,'Visible','Off')
tmp = findall(t1Figure,'ToolTipString','Insert Legend');
set(tmp,'Visible','Off')
tmp = findall(t1Figure,'ToolTipString','Rotate 3D');
set(tmp,'Visible','Off')
tmp = findall(t1Figure,'ToolTipString','Brush/Select Data');
set(tmp,'Visible','Off')
tmp = findall(t1Figure,'ToolTipString','Hide Plot Tools');
set(tmp,'Visible','Off')
tmp = findall(t1Figure,'ToolTipString','Data Cursor');
set(tmp,'Visible','Off')
tmp = findall(t1Figure,'ToolTipString','Insert Colorbar');
set(tmp,'Visible','Off')


% Two axes are needed to trick remove tickmakrs top and right)
ax(1)=axes('Box','On','XTick',[],'YTick',[],'Color','None','Position',[0.1 0.1 0.75 0.70]);
ax(2)=axes('Position',[0.1 0.1 0.75 0.70]);

clvl=[clvl -clvl];

[xax,yax]=meshgrid(t1data.Ppmscale,t1data.T1scale);

[~,hCont]=contour(ax(2),xax,yax,(t1data.T1)',clvl,'k','Parent',ax(2));

set(ax(2),'TickDir','Out');

%if the data contains info on x and y limits - apply these.
if isfield(t1data,'xlim')
    set(ax(2),'Xlim',t1data.xlim);
end
if isfield(t1data,'ylim')
    set(ax(2),'Ylim',t1data.ylim);
end

set(ax(2),'LineWidth',1)
set(hCont,'LineWidth',1)
set(ax(2),'Ydir','reverse');
if t1data.FitType==1
    ylabel(ax(2),'{\fontsize{16}T_1  /s }');
elseif t1data.FitType==2
   ylabel(ax(2),'{\fontsize{16}T_1  /s }');
elseif t1data.FitType==3
    ylabel('\bf T2 /s');
    ylabel(ax(2),'{\fontsize{16}T_2  /s }');
else
    error('unknown FitType')
end


if (isfield(t1data,'NUC1'))
nuc=strtok(t1data.NUC1,'<%d>');
C = regexp(nuc,'(\d+)(\D+)','tokens','once');
num=str2num(C{1,1});
let=C{1,2};

    if num==1 && contains(let,'H')==1      
    set(ax(2),'Xdir','reverse');
    xlabel(ax(2),'{\fontsize{16}\delta(^{1}H)  }');
    
    elseif num==2 && contains(let,'H')==1   
    set(ax(2),'Xdir','reverse');
    xlabel(ax(2),'{\fontsize{16}\delta(^{2}H)  }');
    
    elseif num==10 && contains(let,'B')==1   
    set(ax(2),'Xdir','reverse');
    xlabel(ax(2),'{\fontsize{16}\delta(^{10}B)  }');
    
 elseif num==11 && contains(let,'B')==1   
    set(ax(2),'Xdir','reverse');
    xlabel(ax(2),'{\fontsize{16}\delta(^{11}B)  }');
     
 elseif num==13 && contains(let,'C')==1    
    set(ax(2),'Xdir','reverse');
    xlabel(ax(2),'{\fontsize{16}\delta(^{13}C)  }');
     
    elseif num==14 && contains(let,'N')==1     
    set(ax(2),'Xdir','reverse');
    xlabel(ax(2),'{\fontsize{16}\delta(^{14}N)  }');
    
    elseif num==15 && contains(let,'N')==1     
    set(ax(2),'Xdir','reverse');
    xlabel(ax(2),'{\fontsize{16}\delta(^{15}N)  }');
    
    elseif num==17 && contains(let,'O')==1     
    set(ax(2),'Xdir','reverse');
    xlabel(ax(2),'{\fontsize{16}\delta(^{17}O)  }');
    
    elseif num==19 && contains(let,'F')==1
    set(ax(2),'Xdir','reverse');
    xlabel(ax(2),'{\fontsize{16}\delta(^{19}F)  }');
    
    else 
    
    set(ax(2),'Xdir','reverse');
    xlabel(ax(2),'{\fontsize{16}\delta(^{1}H)  }');
    end 
 
else % assume proton if not defined
set(ax(2),'Xdir','reverse');
    xlabel(ax(2),'{\fontsize{16}\delta(^{1}H)  }');
end 

ax(3)=subplot('Position',[0.1 0.82 0.75 0.15]);
h=plot(t1data.Ppmscale, t1data.Spectrum,'-k','Parent',ax(3) );


axis('tight')
axis('off')
set(h,'LineWidth',1)
set(h,'Color','k')

set(ax(2),'Box','Off', 'Color', 'None');
set(ax(2),'Xdir','reverse');
set(ax(3),'Xdir','reverse');
set(ax,'FontName','Arial','FontWeight','Normal','LineWidth',1, 'FontSize',12);
xlim(t1data.xlim);
ylim=(t1data.ylim);
linkaxes([ax(2) ax(3)], 'x');


end
%---------------------END of dosyplot--------------------------------------



