function dosyresidualcompare(dosydata,dosyguidata)

%% Changes
%%  dosyresidualcompare info

%   dosyresidualcompare (dosydata, npeak);
%   dosyresidualcompare.m: compares the residual in dosy data as obtained from dosy_mn.m
%
%   --------------------------------INPUT------------------------------------
%   dosydata  =  The data structure from dosy_mn
%   npeak     =   peak number
%
%   Example:
%
%   See also: dosy_mn, score_mn, decra_mn, mcr_mn, varianimport,
%             brukerimport, jeolimport, peakpick_mn, dosyplot_mn,
%             dosyresidual, dosyplot_gui, scoreplot_mn, decraplot_mn,
%             mcrplot_mn
%
%   This is a part of the DOSYToolbox
%   Copyright  2007-2008  <Mathias Nilsson>%
%   This program is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   This program is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License along
%   with this program; if not, write to the Free Software Foundation, Inc.,
%   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
%
%   Dr. Mathias Nilsson
%   School of Chemistry, University of Manchester,
%   Oxford Road, Manchester M13 9PL, UK
%   Telephone: +44 (0) 161 306 4465
%   Fax: +44 (0)161 275 4598
%   dosyresidual(dosydata,npeak)
% --------------------------------INPUT------------------------------------
%   dosydata  =   The data structure from dosy_mn
%   npeak     =   peak number
%
%% dosyresidualcompare

hCompfig=figure('Color',[1 1 1],...
    'NumberTitle','Off',...
    'MenuBar','none',...
    'Toolbar','Figure',...
    'Name','Compare data');

%Clean up the Toolbar, removing things we don't need
tmp = findall(hCompfig,'ToolTipString','Data Cursor');
set(tmp,'Visible','Off')
tmp = findall(hCompfig,'ToolTipString','New Figure');
set(tmp,'Visible','Off')
tmp = findall(hCompfig,'ToolTipString','Open File');
set(tmp,'Visible','Off')
tmp = findall(hCompfig,'ToolTipString','Link Plot');
set(tmp,'Visible','Off')
tmp = findall(hCompfig,'ToolTipString','Insert Legend');
set(tmp,'Visible','Off')
% tmp = findall(hCompfig,'ToolTipString','Edit Plot');
% set(tmp,'Visible','Off')
tmp = findall(hCompfig,'ToolTipString','Rotate 3D');
set(tmp,'Visible','Off')
tmp = findall(hCompfig,'ToolTipString','Brush/Select Data');
set(tmp,'Visible','Off')
% tmp = findall(hCompfig,'ToolTipString','Hide Plot Tools');
% set(tmp,'Visible','Off')
tmp = findall(hCompfig,'ToolTipString','Insert Colorbar');
set(tmp,'Visible','Off')

hCompare=axes(...
    'FontName','Arial',...
    'Parent',hCompfig,...
    'FontWeight','normal',...
    'LineWidth',1);


colarray=['k' 'r' 'b' 'g' 'c'];
colarray2={'black', 'red' ,'blue' ,'green', 'cyan'};
leg_index=[0 0 0];

if strcmp(dosydata.type,'dosy')|| strcmp(dosydata.type,'ILT') || strcmp(dosydata.type,'locodosy')
    %DOSY type data
    xdata=dosydata.Gzlvl;
elseif strcmp(dosydata.type,'t1/t2')
    %relaxation data
    xdata=dosydata.Tau;
else
    error('Unknown data type')
end

hold on
%axes(hCompare)
for k=1:length(dosyguidata.comparepeaks)
    if (dosyguidata.comparetype(1)==1)
        if dosyguidata.compareuse(k)==1
            norm_max=max(dosydata.ORIGINAL(dosyguidata.comparepeaks(k),:))  ;
            % disp('one')
            plot(hCompare,xdata,...
                (dosydata.ORIGINAL(dosyguidata.comparepeaks(k),:)./norm_max),['x' colarray(k)],'LineWidth',1);
            leg_index(1)=1;
        end
    end
    
    if (dosyguidata.comparetype(2)==1)
        if dosyguidata.compareuse(k)==1
            norm_max=max(dosydata.ORIGINAL(dosyguidata.comparepeaks(k),:))  ;
            if isfield(dosydata,'FITTED_CALC')
                 plot(dosydata.X_CALC,...
                    (dosydata.FITTED_CALC(dosyguidata.comparepeaks(k),:)./norm_max),['-' colarray(k)],'LineWidth',1);
            else
                plot(xdata,...
                    (dosydata.FITTED(dosyguidata.comparepeaks(k),:)./norm_max),['-' colarray(k)],'LineWidth',1);
            end
            leg_index(2)=1;
        end
    end
    
    if (dosyguidata.comparetype(3)==1)
        if dosyguidata.compareuse(k)==1
            norm_max=max(dosydata.ORIGINAL(dosyguidata.comparepeaks(k),:))  ;
            plot(xdata,...
                (dosydata.RESIDUAL(dosyguidata.comparepeaks(k),:)./norm_max),['--o' colarray(k)],'LineWidth',1) ;
            leg_index(3)=1;
        end
    end
end
axis('tight')
leg_pre={'Original' 'Fitted', 'Residual'};
n=1;
for k=1:length(leg_index)
    if leg_index(k)==1
        leg_str{n}=cell2mat(leg_pre(k)) ; 
        n=n+1;
    end
end

% Plot legend
if strcmp(dosydata.type,'dosy')|| strcmp(dosydata.type,'ILT') || strcmp(dosydata.type,'locodosy')
    %DOSY type data
    hleg=legend(leg_str,'Position',[0.78 0.7 0.1 0.2]);
    set(hleg,'Box','off')
elseif strcmp(dosydata.type,'t1/t2')
    %relaxation data
    if dosydata.FitType == 1 % T1 data
        hleg=legend(leg_str,'Position',[0.78 0.6 0.1 0.2]);
        set(hleg,'Box','off')
    else % T1 inv. rec. and T2 data
        hleg=legend(leg_str,'Position',[0.78 0.7 0.1 0.2]);
        set(hleg,'Box','off')
    end
end

hold off

n=2;

set(gca,'LineWidth',1);

ylabel('\fontname{ariel} \bf Amplitude')

% Peak legend
if strcmp(dosydata.type,'dosy')|| strcmp(dosydata.type,'ILT') || strcmp(dosydata.type,'locodosy')
    %DOSY type data
    xlabel('\fontname{ariel} \bf Squared gradient amplitude /(T^2 m^{-2})')
    for k=1:length(dosyguidata.comparepeaks)
        if dosyguidata.compareuse(k)==1
            textptx=xlim(hCompare);
            textpty=ylim(hCompare);
            str=['\color{' cell2mat(colarray2(k)) '} \rm  Peak:' num2str(dosyguidata.comparepeaks(k))];
            text(0.85*(textptx(2)-textptx(1)),0.8*(textpty(2))-n*0.07*(textpty(2)-textpty(1)),str);
            n=n+1;
        end
    end
elseif strcmp(dosydata.type,'t1/t2')
    %relaxation data
    if dosydata.FitType == 1 % T1 data
        xlabel('\fontname{ariel} \bf Time / s')
        for k=1:length(dosyguidata.comparepeaks)
            if dosyguidata.compareuse(k)==1
                textptx=xlim(hCompare);
                textpty=ylim(hCompare);
                str=['\color{' cell2mat(colarray2(k)) '} \rm  Peak:' num2str(dosyguidata.comparepeaks(k))];
                text(0.85*(textptx(2)-textptx(1)),0.1*(textpty(2))-n*0.07*(textpty(2)-textpty(1)),str);
                n=n+1;
            end
        end
    else % T1 inv. rec. and T2 data
        xlabel('\fontname{ariel} \bf Time / s')
        for k=1:length(dosyguidata.comparepeaks)
            if dosyguidata.compareuse(k)==1
                textptx=xlim(hCompare);
                textpty=ylim(hCompare);
                str=['\color{' cell2mat(colarray2(k)) '} \rm  Peak:' num2str(dosyguidata.comparepeaks(k))];
                text(0.85*(textptx(2)-textptx(1)),0.8*(textpty(2))-n*0.07*(textpty(2)-textpty(1)),str);
                n=n+1;
            end
        end
    end
    
else
    error('Unknown data type')
end

end