function dosyresidual(dosydata,npeak)
%% Changes

%% Dosy residual Info
%   dosyresidual (dosydata, npeak);
%   dosyresidual.m: plots the residual in dosy data as obtained from dosy_mn.m
%
%   --------------------------------INPUT------------------------------------
%   dosydata  =  The data structure from dosy_mn
%   npeak     =   peak number
%
%   Example:
%
%   See also: dosy_mn, score_mn, decra_mn, mcr_mn, varianimport,
%             brukerimport, jeolimport, peakpick_mn, dosyplot_mn,
%             dosyresidual, dosyplot_gui, scoreplot_mn, decraplot_mn,
%             mcrplot_mn
%
%   This is a part of the DOSYToolbox
%   Copyright  2007-2008  <Mathias Nilsson>%
%   This program is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   This program is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License along
%   with this program; if not, write to the Free Software Foundation, Inc.,
%   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
%
%   Dr. Mathias Nilsson
%   School of Chemistry, University of Manchester,
%   Oxford Road, Manchester M13 9PL, UK
%   Telephone: +44 (0) 161 306 4465
%   Fax: +44 (0)161 275 4598
%   dosyresidual(dosydata,npeak)
% --------------------------------INPUT------------------------------------
%   dosydata  =   The data structure from dosy_mn
%   npeak     =   peak number
%
%% dosyresidual

hfig=figure('Color',[1 1 1],...
    'NumberTitle','Off',...
    'MenuBar','none',...
    'Toolbar','Figure',...
    'Name','Fitting plot');

%Clean up the Toolbar, removing things we don't need
tmp = findall(hfig,'ToolTipString','New Figure');
set(tmp,'Visible','Off')
tmp = findall(hfig,'ToolTipString','Open File');
set(tmp,'Visible','Off')
tmp = findall(hfig,'ToolTipString','Link Plot');
set(tmp,'Visible','Off')
tmp = findall(hfig,'ToolTipString','Insert Legend');
set(tmp,'Visible','Off')
% tmp = findall(hfig,'ToolTipString','Edit Plot');
% set(tmp,'Visible','Off')
tmp = findall(hfig,'ToolTipString','Rotate 3D');
set(tmp,'Visible','Off')
tmp = findall(hfig,'ToolTipString','Brush/Select Data');
set(tmp,'Visible','Off')
tmp = findall(hfig,'ToolTipString','Hide Plot Tools');
set(tmp,'Visible','Off')
tmp = findall(hfig,'ToolTipString','Insert Colorbar');
set(tmp,'Visible','Off')

hold on

norm_max=max([max(dosydata.ORIGINAL(npeak.residpeak,:)) max(dosydata.FITTED(npeak.residpeak,:))]);

% Main residual plot
% Fitting plot
if strcmp(dosydata.type,'dosy')|| strcmp(dosydata.type,'ILT') || strcmp(dosydata.type,'locodosy')
    %DOSY type data
    plot(dosydata.Gzlvl,(dosydata.ORIGINAL(npeak.residpeak,:)./norm_max),'xk','LineWidth',1.2)
    hold on
    if isfield(dosydata,'FITTED_CALC')
        plot(dosydata.X_CALC,(dosydata.FITTED_CALC(npeak.residpeak,:)./norm_max),'--r','LineWidth',1);
    else
        plot(xdata,(dosydata.FITTED(npeak.residpeak,:)./norm_max),'--r','LineWidth',1)
    end
    plot(dosydata.Gzlvl,(dosydata.RESIDUAL(npeak.residpeak,:)./norm_max),'b--o','LineWidth',1)
    xlabel('\fontname{ariel} \bf Squared gradient amplitude /(T^2 m^{-2})')
    set(gca,'LineWidth',1);
    axis('tight')
    ylim('auto')
    ylabel('\fontname{ariel} \bf Amplitude')
    str=['\fontname{ariel} \rm Peak Number: ' num2str(npeak.residpeak)];
    text(0.75*max(dosydata.Gzlvl),0.55,str);
    str=['\fontname{ariel} \rm Frequency: ' num2str(dosydata.freqs(npeak.residpeak),3) ' ppm'];
    text(0.75*max(dosydata.Gzlvl),0.48,str);
    nexp=length(find(dosydata.FITSTATS(npeak.residpeak,:)))/4;
    str=['\fontname{ariel} \rm Number of exponentials: ' num2str(nexp,1)];
    text(0.75*max(dosydata.Gzlvl),0.41,str);
    str='\color{black} \rm x   Original';
    text(0.75*max(dosydata.Gzlvl),0.85,str);
    str='\color{red} \rm - -  Fitted';
    text(0.75*max(dosydata.Gzlvl),0.78,str);
    str='\color{blue} \rm - -  Residual';
    text(0.75*max(dosydata.Gzlvl),0.71,str);
    
elseif strcmp(dosydata.type,'t1/t2')
    %relaxation data
    if dosydata.FitType == 1 % T1 data
        plot(dosydata.Tau,(dosydata.ORIGINAL(npeak.residpeak,:)./norm_max),'xk','LineWidth',1.2)
        if isfield(dosydata,'FITTED_CALC')
            plot(dosydata.X_CALC,(dosydata.FITTED_CALC(npeak.residpeak,:)./norm_max),'--r','LineWidth',1);
        else
            plot(xdata,(dosydata.FITTED(npeak.residpeak,:)./norm_max),'--r','LineWidth',1)
        end
        plot(dosydata.Tau,(dosydata.RESIDUAL(npeak.residpeak,:)./norm_max),'b--o','LineWidth',1)
        xlabel('\fontname{ariel} \bf Time / s')
        set(gca,'LineWidth',1);
        axis('tight')
        ylim('auto')
        ylabel('\fontname{ariel} \bf Amplitude')
        str=['\fontname{ariel} \rm Peak Number: ' num2str(npeak.residpeak)];
        text(0.75*max(dosydata.Tau),-0.2,str);
        str=['\fontname{ariel} \rm Frequency: ' num2str(dosydata.freqs(npeak.residpeak),3) ' ppm'];
        text(0.75*max(dosydata.Tau),-0.3,str);
        str='\color{black} \rm +  Original';
        text(0.75*max(dosydata.Tau),0.4,str);
        str='\color{red} \rm - -  Fitted';
        text(0.75*max(dosydata.Tau),0.3,str);
        str='\color{blue} \rm - -  Residual';
        text(0.75*max(dosydata.Tau),0.2,str);
        
    else  % T1 inv. rec. and T2 data
        plot(dosydata.Tau,(dosydata.ORIGINAL(npeak.residpeak,:)./norm_max),'xk','LineWidth',1.2)
        if isfield(dosydata,'FITTED_CALC')
            plot(dosydata.X_CALC,(dosydata.FITTED_CALC(npeak.residpeak,:)./norm_max),'--r','LineWidth',1);
        else
            plot(xdata,(dosydata.FITTED(npeak.residpeak,:)./norm_max),'--r','LineWidth',1)
        end
        plot(dosydata.Tau,(dosydata.RESIDUAL(npeak.residpeak,:)./norm_max),'b--o','LineWidth',1)
        xlabel('\fontname{ariel} \bf Time / s')
        set(gca,'LineWidth',1);
        axis('tight')
        ylim('auto')
        ylabel('\fontname{ariel} \bf Amplitude')
        str=['\fontname{ariel} \rm Peak Number: ' num2str(npeak.residpeak)];
        text(0.75*max(dosydata.Tau),0.55,str);
        str=['\fontname{ariel} \rm Frequency: ' num2str(dosydata.freqs(npeak.residpeak),3) ' ppm'];
        text(0.75*max(dosydata.Tau),0.48,str);
        str='\color{black} \rm +  Original';
        text(0.75*max(dosydata.Tau),0.85,str);
        str='\color{red} \rm - -  Fitted';
        text(0.75*max(dosydata.Tau),0.78,str);
        str='\color{blue} \rm - -  Residual';
        text(0.75*max(dosydata.Tau),0.71,str);
    end
else
    error('Unknown data type')
end

end

