function scoreplot(scoredata)
% function scoreplot(scoredata)
%   scoreplot.m: plots score data as obtained from score_mn.m
%
%   --------------------------------INPUT------------------------------------
%   scoredata  =  The data structure from score_mn
%
%   Example:
%
%   See also: dosy_mn, score_mn, decra_mn, mcr_mn, varianimport,
%             brukerimport, jeolimport, peakpick_mn, dosyplot_mn,
%             dosyresidual, dosyplot_gui, scoreplot_mn, decraplot_mn,
%             mcrplot_mn
%
%   This is a part of the GNAT
%   Copyright  2017  <Mathias Nilsson>%
%   This program is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   This program is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License along
%   with this program; if not, write to the Free Software Foundation, Inc.,
%   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
%
%   Dr. Mathias Nilsson
%   School of Chemistry, University of Manchester,
%   Oxford Road, Manchester M13 9PL, UK
%   Telephone: +44 (0) 161 306 4465
%   Fax: +44 (0)161 275 4598
if nargin==0
    disp(' ')
    disp(' ')
    disp(' SCOREPLOT')
    disp('At least one input is needed')
    disp(' ')
    disp(' Type <<help mcrplot>> for more info')
    disp('  ')
    return
elseif nargin >3
    error(' Too many inputs')
end

scoredata.Dval=[scoredata.Dval;scoredata.Dfix];
scoredata.YScaling=1;

    %% ------------------------NORMAL SCORE plot---------------------
   hMain= figure('Color',[0.9 0.9 0.9],...
       'PaperOrientation','Landscape',...
       'PaperType','A4',...
       'Units','centimeters',...
       'Position',[0 0 29.7 21],...
       'NumberTitle','Off',...
       'MenuBar','none',...
       'Toolbar','Figure',...
       'Name','SCORE/OUTSCORE components plot');
   movegui(hMain,'northwest')

       
%Clean up the Toolbar, removing things we don't need
tmp = findall(hMain,'ToolTipString','New Figure');
set(tmp,'Visible','Off')
tmp = findall(hMain,'ToolTipString','Edit Plot');
set(tmp,'Visible','Off')
tmp = findall(hMain,'ToolTipString','Open File');
set(tmp,'Visible','Off')
tmp = findall(hMain,'ToolTipString','Data Cursor');
set(tmp,'Visible','Off')
tmp = findall(hMain,'ToolTipString','Link Plot');
set(tmp,'Visible','Off')
tmp = findall(hMain,'ToolTipString','Insert Legend');
set(tmp,'Visible','Off')
tmp = findall(hMain,'ToolTipString','Rotate 3D');
set(tmp,'Visible','Off')
tmp = findall(hMain,'ToolTipString','Brush/Select Data');
set(tmp,'Visible','Off')
tmp = findall(hMain,'ToolTipString','Hide Plot Tools');
set(tmp,'Visible','Off')
tmp = findall(hMain,'ToolTipString','Data Cursor');
set(tmp,'Visible','Off')
tmp = findall(hMain,'ToolTipString','Insert Colorbar');
set(tmp,'Visible','Off')


    set(0,"CurrentFigure",hMain)
    ax1=zeros(1,(scoredata.ncomp));
    ax2=zeros(1,(scoredata.ncomp));
    for k=1:scoredata.ncomp
        ax1(k)=subplot(scoredata.ncomp,6,[(k-1)*6+1 (k-1)*6+4]);
        
        h=plot(scoredata.Ppmscale,scoredata.COMPONENTS(k,:),'Parent',ax1(k),'LineWidth',1);
        
        set(gca,'Xdir','reverse');
        axis('tight')
        if (min(min(scoredata.COMPONENTS))-0.1*max(max(scoredata.COMPONENTS))) > max(max(scoredata.COMPONENTS))*1.1
            %fix if data are not sensible, sometimes seems to happen in
            %LOCODOSY
            ylim([max(max(scoredata.COMPONENTS))*1.1 (min(min(scoredata.COMPONENTS))-0.1*max(max(scoredata.COMPONENTS)))])
        else
            ylim([(min(min(scoredata.COMPONENTS))-0.1*max(max(scoredata.COMPONENTS))) max(max(scoredata.COMPONENTS))*1.1])
        end
        set(h,'LineWidth',1)
        set(gca,'LineWidth',1)
        if scoredata.Options(6)==0
            if k==1
                title({'','\fontname{ariel} \bf SCORE components',''});
            end
        end
        if scoredata.Options(6)==1
            if k==1
                title({'','\fontname{ariel} \bf OUTSCORE components',''});
            end
        end
        if scoredata.Options(6)==2
            if k==1
                title({'','\fontname{ariel} \bf HYSCORE components',''});
            end
        end
        
        if k==scoredata.ncomp
            xlabel('\fontname{ariel} \bf Chemical shift /ppm');
        end
        
        ax2(k)=subplot(scoredata.ncomp,6,[(k-1)*6+5 (k-1)*6+6]);
        plot(scoredata.Gzlvl.^2,scoredata.DECAYS(:,k)/max(scoredata.DECAYS(:,k)),'LineWidth',1,'Parent',ax2(k))
        xlim([-0.1 1])
        
        axis('tight')
        ylim('auto');
        set(h,'LineWidth',1);
        set(gca,'LineWidth',1);
        str=['\fontname{ariel} \bf D : ' num2str((scoredata.Dval(k)),3),' ', char(hex2dec('D7')) ,'10^{-10} m^{2} s^{-1} ' ];
        text(0.3*max(scoredata.Gzlvl.^2),0.9,str);
        str=['\fontname{ariel} \bf % : ' num2str(100*(scoredata.relp(k)/sum(scoredata.relp)),3)];
        text(0.3*max(scoredata.Gzlvl.^2),0.80,str);
        
        if k==scoredata.ncomp
            xlabel('\fontname{ariel} \bf Squared gradient amplitud /(T^2 m^{-2})');
        end
    end
    set(ax1,'FontName','Arial','FontWeight','normal','LineWidth',1);
    set(ax2,'FontName','Arial','FontWeight','normal','LineWidth',1);
    linkaxes(ax1,'x');
    linkaxes(ax2,'x');

   %% ------------------------Plotting Diagnistics (Residuals etc )---------------------
   
   if scoredata.diags==1
       % Residuals
       hResid= figure('Color',[0.9 0.9 0.9],...
           'NumberTitle','Off',...
           'MenuBar','none',...
           'Toolbar','Figure',...
           'Visible','off',...
           'Name','SCORE/OUTSCORE Residual variance');
       %movegui(hResid,'southwest');

       %Clean up the Toolbar, removing things we don't need
       tmp = findall(hResid,'ToolTipString','New Figure');
       set(tmp,'Visible','Off')
       tmp = findall(hResid,'ToolTipString','Edit Plot');
       set(tmp,'Visible','Off')
       tmp = findall(hResid,'ToolTipString','Open File');
       set(tmp,'Visible','Off')
       tmp = findall(hResid,'ToolTipString','Data Cursor');
       set(tmp,'Visible','Off')
       tmp = findall(hResid,'ToolTipString','Link Plot');
       set(tmp,'Visible','Off')
       tmp = findall(hResid,'ToolTipString','Insert Legend');
       set(tmp,'Visible','Off')
       tmp = findall(hResid,'ToolTipString','Rotate 3D');
       set(tmp,'Visible','Off')
       tmp = findall(hResid,'ToolTipString','Brush/Select Data');
       set(tmp,'Visible','Off')
       tmp = findall(hResid,'ToolTipString','Hide Plot Tools');
       set(tmp,'Visible','Off')
       tmp = findall(hResid,'ToolTipString','Data Cursor');
       set(tmp,'Visible','Off')
       tmp = findall(hResid,'ToolTipString','Insert Colorbar');
       set(tmp,'Visible','Off')


       axres(1)=subplot(1,6,[1,4]);
       plot(scoredata.Ppmscale,stdnan(scoredata.RESIDUALS').^2)
       ylabel('Residual variance');
       xlabel('\fontname{ariel} \bf Chemical shift /ppm');
       set(gca,'Xdir','reverse');

       axres(2)=subplot(1,6,[5,6]);
       plot(scoredata.Gzlvl.^2,stdnan(scoredata.RESIDUALS).^2)
       hold on
       plot(scoredata.Gzlvl.^2,stdnan(scoredata.RESIDUALS).^2,'r+')
       ylabel('Residual variance');
       xlabel('\fontname{ariel} \bf Squared gradient amplitud /(T^2 m^{-2})');
       %movegui(hResid,'southeast')

       %Leverages
       hLev=  figure('Color',[0.9 0.9 0.9],...
           'NumberTitle','Off',...
           'MenuBar','none',...
           'Toolbar','Figure',...
           'Visible','off',...
           'Name','SCORE/OUTSCORE Leverage');

       %Clean up the Toolbar, removing things we don't need
       tmp = findall(hLev,'ToolTipString','New Figure');
       set(tmp,'Visible','Off')
       tmp = findall(hLev,'ToolTipString','Edit Plot');
       set(tmp,'Visible','Off')
       tmp = findall(hLev,'ToolTipString','Open File');
       set(tmp,'Visible','Off')
       tmp = findall(hLev,'ToolTipString','Data Cursor');
       set(tmp,'Visible','Off')
       tmp = findall(hLev,'ToolTipString','Link Plot');
       set(tmp,'Visible','Off')
       tmp = findall(hLev,'ToolTipString','Insert Legend');
       set(tmp,'Visible','Off')
       tmp = findall(hLev,'ToolTipString','Rotate 3D');
       set(tmp,'Visible','Off')
       tmp = findall(hLev,'ToolTipString','Brush/Select Data');
       set(tmp,'Visible','Off')
       tmp = findall(hLev,'ToolTipString','Hide Plot Tools');
       set(tmp,'Visible','Off')
       tmp = findall(hLev,'ToolTipString','Data Cursor');
       set(tmp,'Visible','Off')
       tmp = findall(hLev,'ToolTipString','Insert Colorbar');
       set(tmp,'Visible','Off')

       % movegui(hLev,'south')
       axlev(1)=subplot(1,6,[1,4]);
       T=scoredata.COMPONENTS';
       h1=diag(T*pinv(T'*T)*T');
       plot(scoredata.Ppmscale,h1,'+','color','black')
       ylabel('Leverage');
       xlabel('\fontname{ariel} \bf Chemical shift / ppm');
       for i=1:length(h1)
           text(scoredata.Ppmscale(i),h1(i),num2str(i))
       end
       set(gca,'Xdir','reverse');

       axlev(2)=subplot(1,6,[5,6]);
       P=scoredata.DECAYS;
       h2=diag(P*P');
       plot(scoredata.Gzlvl.^2,h2)
       St=scoredata.Gzlvl.^2;
       for i=1:length(h2)
           text(St(i),h2(i),num2str(i))
       end
       ylabel('Leverage');
       xlabel('\fontname{ariel} \bf Squared gradient amplitud /(T^2 m^{-2})');

       %Leverages vs. Resduals

       hLevResid=  figure('Color',[0.9 0.9 0.9],...
           'NumberTitle','Off',...
           'MenuBar','none',...
           'Toolbar','Figure',...
           'Visible','off',...
           'Name','SCORE/OUTSCORE Leverage vs Residual');
       %movegui(hLevResid,'southwest');


       %Clean up the Toolbar, removing things we don't need
       tmp = findall(hLevResid,'ToolTipString','New Figure');
       set(tmp,'Visible','Off')
       tmp = findall(hLevResid,'ToolTipString','Edit Plot');
       set(tmp,'Visible','Off')
       tmp = findall(hLevResid,'ToolTipString','Open File');
       set(tmp,'Visible','Off')
       tmp = findall(hLevResid,'ToolTipString','Data Cursor');
       set(tmp,'Visible','Off')
       tmp = findall(hLevResid,'ToolTipString','Link Plot');
       set(tmp,'Visible','Off')
       tmp = findall(hLevResid,'ToolTipString','Insert Legend');
       set(tmp,'Visible','Off')
       tmp = findall(hLevResid,'ToolTipString','Rotate 3D');
       set(tmp,'Visible','Off')
       tmp = findall(hLevResid,'ToolTipString','Brush/Select Data');
       set(tmp,'Visible','Off')
       tmp = findall(hLevResid,'ToolTipString','Hide Plot Tools');
       set(tmp,'Visible','Off')
       tmp = findall(hLevResid,'ToolTipString','Data Cursor');
       set(tmp,'Visible','Off')
       tmp = findall(hLevResid,'ToolTipString','Insert Colorbar');
       set(tmp,'Visible','Off')

       axlev(1)=subplot(1,6,[1,4]);
       r1=stdnan(scoredata.RESIDUALS');
       plot(h1,r1,'+','color','black')
       ylabel('Standard deviation');
       xlabel('Leverage');
       for i=1:length(r1)
           text(h1(i),r1(i),num2str(i))
       end

       axlev(2)=subplot(1,6,[5,6]);
       r2=stdnan(scoredata.RESIDUALS);
       plot(h2,r2,'+','color','black')
       for i=1:length(r2)
           text(h2(i),r2(i),num2str(i))
       end
       xlabel('Leverage');

       set(hResid,'Visible','On')
       set(hLev,'Visible','On')
       set(hLevResid,'Visible','On')
   end


end

