function rscoreplot(rscoredata)
% function rscoreplot(rscoredata)
%   rscoreplot.m: plots score data as obtained from score_mn.m
%
%   --------------------------------INPUT------------------------------------
%   rscoredata  =  The data structure from rscore_mn
%
%   Example:
%
%   See also: dosy_mn, score_mn, decra_mn, mcr_mn, varianimport,
%             brukerimport, jeolimport, peakpick_mn, dosyplot_mn,
%             dosyresidual, dosyplot_gui, scoreplot_mn, decraplot_mn,
%             mcrplot_mn
%
%   This is a part of the GNAT
%   Copyright  2017  <Mathias Nilsson>%
%   This program is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   This program is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License along
%   with this program; if not, write to the Free Software Foundation, Inc.,
%   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
%
%   Dr. Mathias Nilsson
%   School of Chemistry, University of Manchester,
%   Oxford Road, Manchester M13 9PL, UK
%   Telephone: +44 (0) 161 306 4465
%   Fax: +44 (0)161 275 4598
if nargin==0
    disp(' ')
    disp(' ')
    disp(' RSCOREPLOT')
    disp('At least one input is needed')
    disp(' ')
    disp(' Type <<help mcrplot>> for more info')
    disp('  ')
    return
elseif nargin >3
    error(' Too many inputs')
end


rscoredata.YScaling=1;

 % Produce a normal SCORE plot
    %% ------------------------NORMAL SCORE plot---------------------
   
    rMain= figure('Color',[0.9 0.9 0.9],...
       'PaperOrientation','Landscape',...
       'PaperType','A4',...
       'Units','centimeters',...
       'Position',[0 0 29.7 21],...
       'NumberTitle','Off',...
       'MenuBar','none',...
       'Toolbar','Figure',...
       'Name','RSCORE components plot');
    
   %Clean up the Toolbar, removing things we don't need
   tmp = findall(rMain,'ToolTipString','New Figure');
   set(tmp,'Visible','Off')
   tmp = findall(rMain,'ToolTipString','Edit Plot');
   set(tmp,'Visible','Off')
   tmp = findall(rMain,'ToolTipString','Open File');
   set(tmp,'Visible','Off')
   tmp = findall(rMain,'ToolTipString','Data Cursor');
   set(tmp,'Visible','Off')
   tmp = findall(rMain,'ToolTipString','Link Plot');
   set(tmp,'Visible','Off')
   tmp = findall(rMain,'ToolTipString','Insert Legend');
   set(tmp,'Visible','Off')
   tmp = findall(rMain,'ToolTipString','Rotate 3D');
   set(tmp,'Visible','Off')
   tmp = findall(rMain,'ToolTipString','Brush/Select Data');
   set(tmp,'Visible','Off')
   tmp = findall(rMain,'ToolTipString','Hide Plot Tools');
   set(tmp,'Visible','Off')
   tmp = findall(rMain,'ToolTipString','Data Cursor');
   set(tmp,'Visible','Off')
   tmp = findall(rMain,'ToolTipString','Insert Colorbar');
   set(tmp,'Visible','Off')
   
   ax1=zeros(1,(rscoredata.ncomp));
   ax2=zeros(1,(rscoredata.ncomp));
   for k=1:rscoredata.ncomp
       ax1(k)=subplot(rscoredata.ncomp,6,[(k-1)*6+1 (k-1)*6+4]);
       
       h=plot(rscoredata.Ppmscale,rscoredata.COMPONENTS(k,:),'Parent',ax1(k),'LineWidth',1);
       
       set(gca,'Xdir','reverse');
       axis('tight')
       ylim([(min(min(rscoredata.COMPONENTS))-0.1*max(max(rscoredata.COMPONENTS))) max(max(rscoredata.COMPONENTS))*1.1])
       set(h,'LineWidth',1)
        set(gca,'LineWidth',1)
        if k==1
            title({'','\fontname{ariel} \bf RSCORE components',''})
        end
        if k==rscoredata.ncomp
            xlabel('\fontname{ariel} \bf Chemical shift / ppm');
        end
        
        ax2(k)=subplot(rscoredata.ncomp,6,[(k-1)*6+5 (k-1)*6+6]);
        plot(rscoredata.d2,rscoredata.DECAYS(:,k)/max(rscoredata.DECAYS(:,k)),'LineWidth',1,'Parent',ax2(k))
        xlim([-0.1 1])
        
        axis('tight')
        ylim('auto');
        set(h,'LineWidth',1);
        set(gca,'LineWidth',1);
        str=['\fontname{ariel} \bf T1/T2 : ' num2str((rscoredata.Rval(k)),3),' ',' s' ];
        text(0.5*max(rscoredata.d2),0.45,str);
        str=['\fontname{ariel} \bf % : ' num2str(100*(rscoredata.relp(k)/sum(rscoredata.relp)),3)];
        text(0.5*max(rscoredata.d2),0.3,str);
        
        if k==rscoredata.ncomp
            xlabel('\fontname{ariel} \bf Time / s');
        end
    end
    set(ax1,'FontName','Arial','FontWeight','normal','LineWidth',1);
    set(ax2,'FontName','Arial','FontWeight','normal','LineWidth',1);
    linkaxes(ax1,'x');
    linkaxes(ax2,'x');
end



