%
% A Macro to reproduce Fig 2 in Chem. Commun., 2012, 48, 811-813. Original
% was mde in VnmrJ and Illustrator


% Import the data. It is best to import data before making figure as the
% import can otherwise mess up the figure handles  

TmpVar.ImpFID1='/Users/mbdssln2/MNDocs/General NMR Analysis Tolbox/MacroExampleData/PROJECT/Clari_new_cpmg_8ms.fid';
Import_Varian([],[],TmpVar.ImpFID1);
AutoBaselineButton_Callback();
TmpVar.cpmg=NmrData;

TmpVar.ImpFID1='/Users/mbdssln2/MNDocs/General NMR Analysis Tolbox/MacroExampleData/PROJECT/Clari_new_PROJ_8ms.fid';
Import_Varian([],[],TmpVar.ImpFID1);
AutoBaselineButton_Callback();
TmpVar.proj=NmrData;


%Make the figure with the desired size
TmpVar.hFigure = figure(...
    'Units','centimeters',...
    'Color','white',...
    'NumberTitle','Off',...
    'Tag','hFigure',...
    'Toolbar','Figure',...
    'Position',[0.0 0.0 16 20 ]);
 
%Plot the first (cpmg) full spectrum 
TmpVar.hAxes1 = axes(...
    'Units','centimeters',...
    'Box','Off',...
    'Position',[0.5 13 15 6 ]); %set the positin

plot(TmpVar.cpmg.Specscale,real(TmpVar.cpmg.SPECTRA(:,1)),'Color','Black',...
    'LineWidth',2)
TmpVar.hAxes1.YAxis.Visible = 'off'; 
TmpVar.hAxes1.XAxis.Visible = 'off';
xlim([-0.1 5.5])
set(TmpVar.hAxes1, 'Box','Off','Xdir','Reverse') %need to reverse the direction of xscale for NMR data

%Plot the second (proj) full spectrum 
TmpVar.hAxes3 = axes(...
    'Units','centimeters',...
    'Box','Off',...
    'Position',[0.5 7 15 6 ]);

plot(TmpVar.proj.Specscale,real(TmpVar.proj.SPECTRA(:,1)),'Color','Black',...
    'LineWidth',2)
TmpVar.hAxes3.YAxis.Visible = 'off'; 

xlim([-0.1 5.5])
set(TmpVar.hAxes3, 'Box','Off','Xdir','Reverse','TickDir','Out')

%Plot the zoomed in array for cpmg
TmpVar.k=1;

while TmpVar.k<=7
    TmpVar.x_width=0.9;
    TmpVar.x_pos=0.5+(TmpVar.k-1)*(TmpVar.x_width +0.1);
    TmpVar.hAxes2 = axes(...
        'Units','centimeters',...
        'Box','Off',...
        'Position',[TmpVar.x_pos 0 TmpVar.x_width 6 ]);
    plot(TmpVar.cpmg.Specscale,real(TmpVar.cpmg.SPECTRA(:,TmpVar.k)),'Color','Black',...
        'LineWidth',2)
    
    xlim([4.3 4.5])
    ylim([-2 2]*1e6)
    set(TmpVar.hAxes2, 'Box','Off','Xdir','Reverse')
    TmpVar.hAxes2.YAxis.Visible = 'off';
    TmpVar.hAxes2.XAxis.Visible = 'off';
    
    TmpVar.k=TmpVar.k+1;
end

%Plot the zoomed in array for project
TmpVar.k=1;

while TmpVar.k<=7
    TmpVar.x_width=0.9;
    TmpVar.x_pos=8.5+(TmpVar.k-1)*(TmpVar.x_width +0.1);
    TmpVar.hAxes2 = axes(...
        'Units','centimeters',...
        'Box','Off',...
        'Position',[TmpVar.x_pos 0 TmpVar.x_width 6 ]);
    plot(TmpVar.proj.Specscale,real(TmpVar.proj.SPECTRA(:,TmpVar.k)),'Color','Black',...
        'LineWidth',2)
    
    xlim([4.3 4.5])
    ylim([-2 2]*1e6)
    set(TmpVar.hAxes2, 'Box','Off','Xdir','Reverse')
    TmpVar.hAxes2.YAxis.Visible = 'off';
    TmpVar.hAxes2.XAxis.Visible = 'off';
    
    TmpVar.k=TmpVar.k+1;
end
 
% 





