function [magritekdata]=magritek_import_array(inpath)

if isunix==1
    OSslash='/';
else
    OSslash='\';
end
Filepath=[inpath OSslash];

path=dir([Filepath 'acqu.par']);

Filepath2=[Filepath OSslash path.name];
Magritek.par=GetParameters(Filepath2);
format long;

%expert and basic use different values for the o1 value
magdata.np=str2double(Magritek.par.nrPnts);
magdata.bf1=str2double(strrep((Magritek.par.b1Freq),"""",''));
magdata.swh=str2double(Magritek.par.bandwidth)*1000;
magdata.sw=magdata.swh/magdata.bf1;
magdata.Lfreq=str2double(Magritek.par.lowestFrequency);
magdata.o1=magdata.Lfreq+(magdata.swh/2);
magdata.o1p=magdata.o1/magdata.bf1;
magdata.sf=magdata.bf1-(magdata.o1p*magdata.bf1*10^-6);
magdata.sfo1=magdata.bf1-(magdata.o1p*magdata.bf1*10^-6);
magdata.sp=magdata.Lfreq/magdata.bf1;
magdata.lp=0;
magdata.rp=0;
magdata.sfrq=magdata.sfo1;
%magdata.at=str2double(Magritek.par.totalAcquisitionTime)/1000;
magdata.at=magdata.np/(magdata.sw*magdata.sfrq);
magdata.NUC1=strrep((Magritek.par.rxChannel),"""",'');
magdata.ni=str2double(Magritek.par.nrSteps);

switch magdata.NUC1
    case '1H'
        magdata.gamma=267524618.573;
           case '2H'
             magdata.gamma=41066000;
        case '10B'
             magdata.gamma=28747000;
        case '11B'
            magdata.gamma=85847000;
        case '13C'
            magdata.gamma=67283000;
        case '14N'
            magdata.gamma=19338000;
        case '15N'
            magdata.gamma=-27126000;
        case '17O'
            magdata.gamma=-36281000;
        case '19F'
            magdata.gamma=251815000;
        case '23Na'
            magdata.gamma=70808000;
        case '27Al'
            magdata.gamma=69764000;
        case '29Si'
            magdata.gamma=-53190000;
        case '31P'
            magdata.gamma=108394000;
            
            otherwise
            logtext='unknown nucleus - defaulting to proton';
            disp(logtext)

            magdata.gamma=267524618.573;  
end 

% check if there is a delay list and import values

if isempty(dir(fullfile(pwd,'delayTimes*')))==0 % assume relaxation delays
vdpath=struct2cell(dir(fullfile(Filepath ,'delayTimes*')));
magdata.vd=readmatrix([vdpath{2} '/' vdpath{1}],"DecimalSeparator",",","Delimiter"," ");
end 
%% Import magritex raw fids from data.2d
np=magdata.np;
ni=magdata.ni;
path2=dir([Filepath OSslash 'data.2d']);
inpath=[Filepath OSslash path2.name];
file=fopen(inpath);
raw_data=fread(file,Inf,'float',0,'l');
fclose(file);

% The first 8 points correspond to the keys: owner format, version,
% datatype, xdim,ydim, zdim and qdim I will remove them

raw_data(1:8)=[];
fid=reshape(raw_data,np*2,ni);
compfid=complex(fid(1:2:end,:),fid(2:2:end,:));
magdata.fid=compfid;
magritekdata=magdata;
end 

%% Utility functions
% GetParameters will parse the acqu.par file

function OutParams=GetParameters(Filepath2)
file=fopen(Filepath2);

while ~feof(file)
    parmline=fgetl(file);
    %remove the annoying spaces
    parmline=strrep(parmline,' ','');
parmend=find(parmline=='=');
if max(isstrprop(parmline(1),'digit'))==1
        continue;
elseif isempty(strfind(parmline,""""))==0
procpar.(parmline(1:(parmend-1)))=parmline((parmend+2):end); 

else 
procpar.(parmline(1:(parmend-1)))=parmline((parmend+1):end);
end 
OutParams=procpar;
end 
fclose(file);
end 
