function [xpulsedata]=X_pulse_import(inpath)

% For the import of data acquired on oxford instruments pulsar and X-pulse
% Should handle spinflow versions upto 3.2


if isunix==1
    OSslash='/';
else
    OSslash='\';
end
Filepath=[inpath OSslash];

% Lets get some parameters from the .jdx file file
path=dir([Filepath 'average' OSslash '*.jdx']);

if isempty(path)
    % check if the average file is in directory above
    path=dir([Filepath OSslash '*.jdx']);
    
    if isempty(path)
        error('jdx file was not found')
    end 
    
    XPULSE.par=GetParameters([Filepath  OSslash path.name]);   
else 
 XPULSE.par=GetParameters([Filepath 'average' OSslash path.name]);   
end 




%put the parameters I need into GNAT format
xpulsedata.DataDim=str2double(XPULSE.par.NUMDIM);
xpulsedata.sf=str2double(XPULSE.par.SF);
xpulsedata.sw=str2double(XPULSE.par.Filter)/xpulsedata.sf;
xpulsedata.sfo1=str2double(XPULSE.par.SFO1);
xpulsedata.o1=str2double(XPULSE.par.TxPPM);
xpulsedata.sp=(xpulsedata.o1-(xpulsedata.sw/2));
xpulsedata.lp=0;
xpulsedata.rp=0;
xpulsedata.np=str2double(XPULSE.par.TD)/2;
xpulsedata.sfrq=str2double(XPULSE.par.SFO1);
xpulsedata.at=xpulsedata.np/(xpulsedata.sw*xpulsedata.sfrq);
xpulsedata.SI=round(str2double(XPULSE.par.SI));
xpulsedata.NCOEF=round(str2double(XPULSE.par.NCOEF));
xpulsedata.TDoff=round(str2double(XPULSE.par.TDoff));
%Get the observe nucleus
xpulsedata.NUC1=XPULSE.par.OBSERVENUCLEUS(2:end);


switch xpulsedata.NUC1
    case '1H'
        xpulsedata.gamma=267524618.573;
           case '2H'
             xpulsedata.gamma=41066000;
        case '10B'
             xpulsedata.gamma=28747000;
        case '11B'
            xpulsedata.gamma=85847000;
        case '13C'
            xpulsedata.gamma=67283000;
        case '14N'
            xpulsedata.gamma=19338000;
        case '15N'
            xpulsedata.gamma=-27126000;
        case '17O'
            xpulsedata.gamma=-36281000;
        case '19F'
            xpulsedata.gamma=251815000;
        case '23Na'
            xpulsedata.gamma=70808000;
        case '27Al'
            xpulsedata.gamma=69764000;
        case '29Si'
            xpulsedata.gamma=-53190000;
        case '31P'
            xpulsedata.gamma=108394000;
            
            otherwise
            logtext='unknown nucleus - defaulting to proton';
            disp(logtext)

            xpulsedata.gamma=267524618.573;  
end 

%% Get the complex FID
FID=XPULSE.par.FID;
[m,p]=size(FID);

if p==2
realFID=FID(1:xpulsedata.np,2);

imagFID=FID(xpulsedata.np+1:end,2);

compfid=complex(realFID,imagFID);

elseif p==1
 realFID=FID(1:xpulsedata.np);   
 imagFID=FID(xpulsedata.np+1:end);
 compfid=complex(realFID,imagFID);
 
end 

 xpulsedata.FID=compfid;
end 


%% UTILITY functions
function OutParams=GetParameters(FilePath)
file=fopen(FilePath);

k=1;
while ~feof(file)
  
                   parmline=fgetl(file);
                   if isempty(parmline)
                       continue;
                   elseif strcmp(parmline(1:2),'##')
                       if contains(parmline,'/')
                           continue;
                       end 
                        if parmline(3)=='.'
                        %continue;
                         parmend=find(parmline=='=');
                           if any(isspace(parmline(4:parmend-1)))==1
                               continue;
                           else 
                       
                       parmstart=find(parmline=='.');
                       
                       procpar.(parmline(parmstart+1:parmend-1))=parmline((parmend+2):end);
                            end
                        end
                       if parmline(3)=='$'
                       parmend=find(parmline=='=');
                       procpar.(parmline(4:parmend-1))=parmline((parmend+2):end);
                       
                       elseif parmline(3)~='.'
                       parmend=find(parmline=='=');
                           if any(isspace(parmline(3:parmend-1)))==1
                           continue;
                           end 
                       procpar.(parmline(3:parmend-1))=parmline((parmend+2):end);   
                       end 
                       
                   elseif strcmp(parmline(1:2),'$$')
                         if isempty(find(parmline=='='))==0
                            parmend=find(parmline=='=');
                            procpar.(parmline(3:(parmend-1)))=parmline((parmend+2):end);
                         end 
                   elseif isstrprop(parmline(2),'digit')==1 || isstrprop(parmline(1),'digit')==1%%
                       
                       % This is propably the FID so I will save
                       
                       % digit 1 check works for new versions but not older
                       % versions allow either to enter the loop
                       
                       
                       if ~any(isletter(parmline)) % if line only contains values
                       % disp(parmline)
                       line=split(parmline(2:end));
                       procpar.FID(k,:)=str2double(line);
                       k=k+1;
                       
                       elseif any(isletter(parmline))
                         
                           % codes for decompression of JCAMP files
                            SQZ = 'ihgfedcba@ABCDEFGHI';
                            DIF = 'rqponmlkj%JKLMNOPQR';
                            DUP = 'STUVWXYZs';
                            
                            values = regexp(parmline,'[+-]*[a-s_A-Z_%@]?\d*\.?\d*([Ee][+-]\d+)?','match'); %split at letter

                            xval = sscanf(values{1},'%f'); %get first x value

                            for i=2:length(values)
                                mode=1;
                                num=values{i};
                                %% SORT OUT the SQZ charachters
                                if contains(SQZ,num(1))==1

                                     dig = find(SQZ==num(1))-10;

                                     % replace letter with digit
                                    num = sscanf([sprintf('%d',dig) num(2:end)],'%f');
                                    y(k)=num;
                                    k=k+1;

                                elseif contains(DIF,num(1))==1

                                     digDIF = find(DIF==num(1))-10;

                                     % replace letter with digit
                                    difValue = sscanf([sprintf('%d',digDIF) num(2:end)],'%f');

                                    y(k)=y(k-1)+difValue;
                                    k = k+1;
                                    mode = 2;

                                    elseif contains(DUP,num(1))==1

                                     dupDig = find(DUP==num(1));

                                     if length(num)==1
                                            dupValue = dupDig;
                                        else
                                            dupValue = sscanf([sprintf('%d',dupDig) num(2:end)],'%f');
                                      end

                            %         y(k)=num;
                            %         %k=k+1;

                                    for n = 1:dupValue-1
                                             if mode==1
                                                y(k) = y(k-1);
                                             else
                                                 y(k) = y(k-1)+difValue;
                                             end
                                             k = k+1;
                                    end

                                end 
                                
                                          
                                           procpar.FID=y(:,:);
                            end 
                             if (mode==2)
                                    k = k-1; % rewind one value for the checkpoint
                             end
                              procpar.FID=y(:,:)';
                             
                        end

                        end 
                             
                           
end 
        OutParams=procpar;
        fclose(file);
 end 