# Contributing to GNAT (General NMR Analysis Toolbox)

Thank you for your interest in contributing to GNAT.

GNAT is developed primarily by scientists (mostly chemists) who code intermittently.  
This document is designed to keep the workflow as simple and forgiving as possible, while
still giving the maintainer a clear overview of changes.

If anything here is unclear or feels too complicated, please open an issue and say so.

---

## 1. Roles and responsibilities

- **Maintainer**  
  The maintainer (currently: project PI) has overall responsibility for:
  - Reviewing and merging pull requests (PRs).
  - Deciding when to cut new releases.
  - Keeping the main branch in a usable state.

As a convention, only the maintainer (or explicitly nominated maintainers) should merge pull
requests into `master`. Contributors should not merge their own PRs; instead, assign the
maintainer or @-mention them when a PR is ready for review.


- **Contributors** (students, PDRAs, collaborators, etc.)  
  - Work on short-lived branches created from `master`.
  - Do **not** push directly to `master`.
  - Use GitHub Desktop where possible; the command line is optional.

---

## 2. Repository structure and branches

The GNAT Git repository uses a very simple structure:

- `master`  
  - Main development branch.  
  - Always contains the latest stable GNAT code.

- `GNAT-2.0`  
  - Historical branch corresponding to the GNAT 2.0 release distributed to end-users.

- **Feature branches**  
  - Short-lived branches for specific pieces of work.  
  - Examples:
    - `MN-bugfix-Bruker-RD-export`
    - `AA-feature-LOCODOSY`
    - `XX-docs-installation-update`
  - Created from `master`, merged into `master` via pull requests, then deleted.

- **Tags and releases**  
  - Official versions are marked with tags and GitHub Releases, e.g. `GNAT-2.0`, `GNAT-2.1`, …
  - Releases are created by the maintainer from the `master` branch.

---

## 3. Prerequisites

To contribute, you will need:

- A GitHub account.
- **GitHub Desktop** installed and logged in.  
- A reasonably recent version of **MATLAB** with the toolboxes you need for your work  
  (see `README.md` for any version notes).
- Basic familiarity with MATLAB `.m` files.

You do *not* need to be comfortable with the git command line.

---

## 4. One-time setup (cloning GNAT)

1. Open **GitHub Desktop**.
2. Go to **File → Clone repository…**.
3. In the **GitHub.com** tab, select the `UoM_GNAT` repository.
4. Choose a local path, e.g. `Documents/GitHub/UoM_GNAT`.

   **Important:** avoid placing the clone inside a synchronised folder such as OneDrive,
   Dropbox, iCloud Drive, or similar. These tools can interfere with git’s internal `.git`
   directory and cause mysterious errors or conflicts. A simple path like
   `~/Documents/GitHub/UoM_GNAT` (outside any sync service) is recommended.

5. Click **Clone**.
6. In GitHub Desktop, use **Repository → Show in Finder** to open the folder.
7. In **MATLAB**, set this folder as your current working directory (or add it to the path).

You now have a local copy of GNAT ready for development.

---

## 5. Standard workflow for making changes

This is the normal pattern for any bug fix, small feature, or documentation change.

### 5.1 Update `master`

Before starting new work:

1. In GitHub Desktop, select the `UoM_GNAT` repository.
2. Ensure the **Current branch** (top centre) is `master`.
3. Click **Fetch origin**, then **Pull origin** if offered.

Your local `master` now matches GitHub’s `master`.

### 5.2 Create a feature branch

1. In GitHub Desktop, click the **Current branch** menu → **New Branch**.
2. Choose a descriptive name, for example:
   - `MN-bugfix-Bruker-RD-export`
   - `AA-feature-LOCODOSY`
3. Ensure the branch is based on `master`.
4. Click **Create branch**.

GitHub Desktop will automatically switch you to this new branch.

### 5.3 Make your changes in MATLAB

1. Edit or add `.m` files as needed.
2. Save your files.
3. Run any relevant scripts or test data to check that GNAT still behaves as expected
   (see Section 6 for expectations).

### 5.4 Commit your changes

In GitHub Desktop, on your feature branch:

1. Go to the **Changes** tab.
2. Review the list of modified files and their diffs.
3. At the bottom, write:
   - **Summary:** a short description (e.g. `Fix Bruker RD export for processed arrays`).
   - **Description:** optional extra details if helpful.
4. Click **Commit to \<branch-name\>**.

Small, logical commits are preferred (easier to review), but do not worry about perfection.

### 5.5 Push your branch to GitHub

After making at least one commit:

1. Click **Publish branch** (first time) or **Push origin** (afterwards).
2. This creates or updates your branch on GitHub under the same name.

### 5.6 Open a Pull Request (PR)

You now ask for your changes to be merged into `master`.

1. In GitHub Desktop, after pushing, click **Create Pull Request…**,  
   or go to the repository on GitHub and click **Pull requests → New pull request**.
2. Set:
   - **Base branch:** `master`
   - **Compare branch:** your feature branch
3. Title the PR clearly:
   - e.g. `Fix Bruker RD export for processed data`
4. In the PR description, include:
   - A brief summary of what you changed.
   - Any relevant details on testing (e.g. data sets used, MATLAB version).
   - Any known limitations.

The maintainer will review your PR, ask for changes if needed, and merge it when ready.

### 5.7 Cleaning up your local branch after merge

After your PR has been merged:

1. In GitHub Desktop, switch to **`master`**.
2. Click **Fetch origin** and **Pull origin** to bring in the merged changes.
3. Switch back to your feature branch.
4. Use **Branch → Delete** to delete the local branch  
   (the remote branch should already have been deleted after the merge).

Your repository is now clean and ready for your next piece of work.

---

## 6. Testing and quality expectations

GNAT does not (yet) have a full automated test suite. For now we use pragmatic checks:

- Before opening a PR, please:
  - Verify that your new functionality works on at least one appropriate data set.
  - Run a small selection of typical GNAT workflows you did *not* modify, to make sure nothing obvious has broken.
  - Avoid adding changes unrelated to your task (no mass reformatting, no large renaming alongside a bug fix).

If your change requires specific test data, mention this in your PR description and, if appropriate, add small anonymised test files to the repository (or link to where they are stored).

---

## 7. MATLAB coding guidelines (lightweight)

To keep the code readable for other scientists:

- Prefer clear, descriptive variable and function names.
- Add brief comments where the intent is not obvious, especially around:
  - File format handling,
  - Non-trivial linear algebra / optimisation,
  - Assumptions about units, dimensions, or data layout.
- Avoid unnecessary global state and side effects where possible.
- Do not rely on very new MATLAB features unless strictly necessary;  
  GNAT aims to work on reasonably recent, but not bleeding-edge, MATLAB releases.

More detailed style guidance (if needed) can be added in a future `DEVELOPERS.md`.

---

## 8. Reporting bugs or requesting features

If you are not ready to write code yourself, you can still help:

- Use the **Issues** tab on GitHub to:
  - Report bugs,
  - Request new features,
  - Ask for documentation clarifications.

When reporting a bug, please include:

- MATLAB version,
- Operating system (Windows/macOS/Linux),
- GNAT version (e.g. `GNAT-2.0`, or the current `master` commit),
- A brief description of the problem,
- If possible, small example data and the exact steps to reproduce the issue.

---

## 9. Maintainer notes (for reference)

These steps are primarily for the maintainer.

### 9.1 Merging PRs

- Review the diff and comments.
- Ensure the PR targets `master`.
- Check it builds/runs as needed.
- Merge when satisfied.
- Delete the remote feature branch after merging.

### 9.2 Creating a new release

When `master` is in a suitable state:

1. On GitHub, go to **Releases → Draft a new release**.
2. Create a new tag (e.g. `GNAT-2.1`) targeting `master`.
3. Set the release title to match the tag (e.g. `GNAT 2.1`).
4. Write short release notes summarising major changes.
5. Publish the release.
6. (Optional) Upload or link this release from the GNAT project homepage.

---

## 10. Questions and help

If you are unsure about any part of this process:

- Open an issue on GitHub with the label `question`, or
- Speak to the maintainer directly if you are in the same group.

We would rather answer a “simple” question than have you stuck or worried about breaking something.
