function f_val = mn_autophase(phases,spectrum)
% Function for autophase of an NMR spectrum
% Inspired by Ernst JMagRes,1, 7-26, 1969 and
% Craight and Marshall JMagRes, 76, 458-475, 1988

Rc=1i*(pi/180);
fn=numel(spectrum);
lpCorr= linspace(0,1,fn)*0; %no linear phase correction as default
if numel(phases)==2
    
    lpChange=-phases(2);
    rpChange=-phases(1);
    
    lpCorr= linspace(0,1,fn)*lpChange;
    phaseCorr=(exp(Rc*(rpChange + lpCorr)))';
    
    
    
elseif numel(phases)==1
    rpChange=-phases(1);
    phaseCorr=(exp(Rc*(rpChange + lpCorr)))';
else
    error('wrong number of phase parameters')
end

spectrum=spectrum.*phaseCorr;
f_val=max(real(spectrum))/min(real(spectrum));
%f_val=1/sum(imag(spectrum));

end