function trimmedArray = clipping(originalArray, percentileToRemove)
%   clipping(originalArray, percentileToRemove); 
%
%   This is a part of the GNAT
%   Copyright  2024  <Mathias Nilsson>%
%   This program is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   This program is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License along
%   with this program; if not, write to the Free Software Foundation, Inc.,
%   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
%
%   Dr. Mathias Nilsson
%   School of Chemistry, University of Manchester,
%   Oxford Road, Manchester M13 9PL, UK
%   Telephone: +44 (0) 161 306 4465
%   Fax: +44 (0)161 275 4598
%
%   Hugo da Silva Rocha, PhD Student
%   School of Chemistry, University of Manchester,
%   hugo.rocha@postgrad.manchester.ac.uk
%   Telephone: +44 (0) 7871080481

%% Clipping the Spectra

  arrayLength = length(originalArray);
  startIndex = ceil(arrayLength * percentileToRemove/2) + 1;
  endIndex = floor(arrayLength * (1 - percentileToRemove/2));
  if size(originalArray,2)>size(originalArray,1)
      originalArray=originalArray';
      trimmedArray = originalArray(startIndex:endIndex,:);
      trimmedArray = trimmedArray';
  else
    trimmedArray = originalArray(startIndex:endIndex,:);
  end
end