function LPestimate(~,~)

% Create a function outside of the Main GNAT script that can still call the
% variables?


global LP % Get the handles LP set in the GNAT.m script

GNATD.data=findobj(allchild(0), 'tag', 'MainFigure');
GNATD.NmrData=guidata(GNATD.data(1)); % Get the NmrData structure from the main window

NPU=0.75*GNATD.NmrData.np;

% estimate the number of signals based on the spectrum
spectrum=GNATD.NmrData.SPECTRA(:,GNATD.NmrData.flipnr);
if GNATD.NmrData.th==0
    errordlg('Please set a threshold')
end 

 peak=peakpick_mn(spectrum,GNATD.NmrData.th);  % take user input for threshold
 peak=table2array(struct2table(peak));

[m,~]=size(peak);

NCOEF=m;
 
 
% Get number of points to predict based on method
        switch get(LP.hBGroupLPOpt1,'SelectedObject') 
            case LP.hRadio1LPOpt1 % Forwards linear prediction
                NPP=GNATD.NmrData.np; % set to predict 2*NP
            case LP.hRadio2LPOpt1 % backwards linear prediction
                if isfield(GNATD.NmrData,'TDoff') == 1
                    NPP=abs(GNATD.NmrData.TDoff)/2; % If already input from data file use that file
                else
                    NPP=8;
                end 
        end
set(LP.hEditNPP,'String',NPP)
set(LP.hEditNCOEF,'String',NCOEF)
set(LP.hEditNPU,'String',NPU)
end 