function complexdata = readfid(filename,bruker_byte_format,bruker_byte_size)
% This program has been created by Jean-Nicolas Dumez Ludmilla Guduff, and 
% Corentin Jacquemmoz,CEISAM, CNRS, Universit de Nantes, France
% The authors are not responsible for the results obtained with the program
% This program can be used, modified and shared as long as the authors are
% credited and the program is share under the same conditions

% Please do not delete this header from the file.

% readfid(filename) reads a binary file that contains 2* npoints, which 
% corresponds to the real and imaginary part of the raw data, interleaved.
% Works only for Bruker data
%          Input parameters
%             - filename; name of the file 
%             - bruker_byte_format; obtained from 'acqus' file 
%             - bruker_byte_size; obtained from 'acqus' file

% Open the file and read 2* npoints
if bruker_byte_format == 0
    byte_format='l'; % little endian
elseif bruker_byte_format == 1
    byte_format='b'; % big endian
else
    error('unknown data format (BYTORDA)')
end

if bruker_byte_size == 0
    byte_size='int32';
elseif bruker_byte_size == 1 || bruker_byte_size == 2
    byte_size='double';
else
    error('unknown data format (DTYPA)')
end

id=fopen(filename, 'r', byte_format);		
[realimag, ~] = fread(id,byte_size); % use int32 for Topspin 3,
%double for Topspin 4 and float32 for ZMagritek
fclose(id);

npoints = length(realimag)/2;

% Combine the real and imaginary parts
complexdata = realimag(1:2:2*npoints-1) + 1i * realimag(2:2:2*npoints);


end