function [GmaxZ,GmaxY,GmaxX] = gradparlist(probe)
% This program has been created by Jean-Nicolas Dumez Ludmilla Guduff, and Corentin Jacquemmoz, 
% CEISAM, CNRS, Universit� de Nantes, France
% The authors are not responsible for the results obtained with this program
% This program can be used, modified and shared as long as the authors are
% credited and the program is share under the same conditions
% Please do not delete this header from the file.
% Lists of probe used and the values of their gradient intensity for each
% axis.

switch probe
    case '<Z3386_0024 (PH MIC 500S2/AS BODY)>' %500 micro imagery Nantes
        GmaxZ = 2.91; %T/m
        GmaxY = 2.91; %T/m
        GmaxX = 2.91; %T/m
    case '<Z837501_0007 (PA BBI 500S2 H-BB-D-05 XYZ)>' %500 BBI Nantes
        GmaxZ = 0.63; %T/m
        GmaxY = 0.556; %T/m
        GmaxX = 0.542; %T/m
    case '<Z8281_170 (TXI 500SB H-C/N-D-05 XYZ)>' %500 TXI Nantes de pret
        GmaxZ = 0.6923; %T/m
        GmaxY = 0.5114; %T/m
        GmaxX = 0.4965; %T/m
    case '<Z8323_0197 (TXI 600SB H-C/N-D-05 XYZ)>' %600X gif
        GmaxZ = 0.65; %T/m
        GmaxY = 0.5; %T/m
        GmaxX = 0.5; %T/m
    case '<Z75812_0078 (CP TCI 600S3 H-C/N-D-05 Z)>' %600G gif
        GmaxZ = 0.535; %T/m
        GmaxY = 0; %T/m
        GmaxX = 0; %T/m
    case '<5 mm BBI 1H/D-BB Z-GRD Z8107/0238 >' %500 CEA
        GmaxZ = 0.535; %T/m
        GmaxY = 0; %T/m
        GmaxX = 0; %T/m
    case '<5 mm TBI 1H/15N/D-BB XYZ-GRD Z105326/0001 >' %500 CEA
        GmaxZ = 0.65; %T/m
        GmaxY = 0.5; %T/m
        GmaxX = 0.5; %T/m
    case '<5 mm PABBO BB-1H/19F/D Z-GRD Z156603/0001 >' %800 ENS
        GmaxZ = 0.535; %T/m
        GmaxY = 0; %T/m
        GmaxX = 0; %T/m
    case '<Z8090_0014 (TBI 600SB)>' % 600X, 31P probe
        GmaxZ = 0.535; %T/m
        GmaxY = 0; %T/m
        GmaxX = 0; %T/m
    case '<5 mm CPDCH 13C-1H/D Z-GRD Z75003/0006 >'
        GmaxZ = 0.666; %T/m
        GmaxY = 0; %T/m
        GmaxX = 0; %T/m
    case '<Z149000_0034 (CPP BBO 400S1 BB-H&F-D-05 Z)>'
        GmaxZ = 0.5582; %T/m
        GmaxY = 0; %T/m
        GmaxX = 0; %T/m
    otherwise % In case the probe is not recognized
        GmaxZ = 0.535; %T/m
        GmaxY = 0; %T/m
        GmaxX = 0; %T/m
        disp('Probe not recognized, default value for gradient is used (0.535 T/m)')
end
