function time = getTime(path,first,jump,last)
% This program has been created by Jean-Nicolas Dumez and Corentin Jacquemmoz, 
% CEISAM, CNRS, Universit de Nantes, France
% The authors are not responsible for the results obtained with this program
% This program can be used, modified and shared as long as the authors are
% credited and the program is share under the same conditions
% Please do not delete this header from the file.
% getTime is a function that get the finissing time of one or several
% experiment(s) in seconds.
% The output variable time is a matrix of size (first:jump:last);

%example of input variables: 
% path = 'C:\data\600X\191008_Saponification_25C/';
% first = 1;
% last = 120;
% jump =2;

if nargin<3
    jump = 1;
    last = first;
end

% Preallocating
hour = zeros(length(first:jump:last),1);
minutes = zeros(length(first:jump:last),1);
sec = zeros(length(first:jump:last),1);
msec = zeros(length(first:jump:last),1);


n=1; 
for i=first:jump:last
     acquparams = readacqus([path num2str(i) '/acqus']);
     %time(n,:) = acquparams.Stamp(12:20);
     hour(n,:) = str2double(acquparams.Stamp(13:14));
     minutes(n,:) = str2double(acquparams.Stamp(16:17));
     sec(n,:) = str2double(acquparams.Stamp(19:20));
     msec(n,:) = str2double(acquparams.Stamp(22:24));
     time = hour*3600+minutes*60+sec+msec/1000;
     n=n+1;
end
%time = time-time(1);
 
end