function wdata=phasecorrection(wdata,parameters)
% This program has been created by Ludmilla Guduff, Jean-Nicolas Dumez and Corentin Jacquemmoz, 
% CEISAM, CNRS, Universit de Nantes, France
% The authors are not responsible for the results obtained with this program
% This program can be used, modified and shared as long as the authors are
% credited and the program is share under the same conditions
% Please do not delete this header from the file.
% taken from https://ucdb.googlecode.com/hg/application/ProSpectND/html/dmx_digital_filters.html
%W. M. Westler and F.  Abildgaard (July 16, 1996)
% http://verahill.blogspot.fr/2012/12/bruker-1d-processing-using-octavematlab.html

%The use of this function can be replaced by manual phasing with 'ph_1d_man' function

%procwaxis = (0:1:parameters.nZF-1)'/(parameters.nZF-1)';
procwaxis = linspace(-0.5,0.5,parameters.nZF)';
m=720;
phc0 = linspace(-360,360,m);
phc1 = parameters.p*360;
c = pi/180;
tmp=size(wdata);
maxsig=0;n=1;
minsig=-inf;

wdata = wdata .* ...
    exp(1i*c*(parameters.phc1man*(procwaxis)));

for k = 1:m       
   wdata1 = wdata .* ...
    exp(1i*c*(phc0(k)+phc1*(procwaxis)));

    wdata1=real(wdata1);
   localmin=min((wdata1));
        localmax=max(wdata1);
        if (localmin>minsig) 
                minsig=localmin;
                n=k;
                
        end
   
end
phc0=phc0(n);

 wdata = wdata .* ...
    exp(1i*c*(phc0+parameters.phc0man+phc1*(procwaxis)));

 
end 
