function [assignment]=uf_assign(CSzg,peaks_start,peaks_stop,ppm_axis,peak_spec, CSuf, CSuf_pos,figonoff)
% This program has been created by Ludmilla Guduff, Jean-Nicolas Dumez and Corentin Jacquemmoz, 
% CEISAM, CNRS, Universit de Nantes, France
% The authors are not responsible for the results obtained with this program
% This program can be used, modified and shared as long as the authors are
% credited and the program is share under the same conditions
% Please do not delete this header from the file.

% Position of CSzg in UF spectrum
assignment=zeros(length(CSzg),5); %[start stop CSzg CSuf posCSuf] peak(s) selected in conv_dim
assignment(:,1) = sort(peaks_start);
assignment(:,2) = sort(peaks_stop);
assignment_temp = [CSzg CSuf CSuf_pos];
assignment(:,3:5) = sortrows(assignment_temp,2);

% Save assignment data
save('assignment.mat','assignment')


switch figonoff
    case 'on'
        %Check peak position
        labels = cellstr( num2str(assignment(:,3)));
        figure;
        plot(ppm_axis,peak_spec);
        hold on
        plot(ppm_axis(assignment(:,1)),peak_spec(assignment(:,1)),'mx');
        plot(ppm_axis(assignment(:,2)),peak_spec(assignment(:,2)),'gx');
        plot(ppm_axis(assignment(:,5)),peak_spec(assignment(:,5)),'r+');
        text(ppm_axis(assignment(:,5)),peak_spec(assignment(:,5)), labels,...
            'VerticalAlignment','bottom','HorizontalAlignment','right');
        title('Labels corresponds to CS position in the zg spectrum')
        legend('UF spectrum','start','stop','CSuf')
        ax=gca;
        set(ax,'Xdir','reverse');
        xlabel('ppm')
        
    case 'off'
        %'no figure is displayed'
        
    otherwise
        
        error('figonoff should be either on or off')
end
end