function [rwdataph]=uf_ph_man_GNAT(rwdata,brukerdata)
% This program has been created by Jean-Nicolas Dumez and Corentin Jacquemmoz, 
% CEISAM, CNRS, Universit� de Nantes, France
% The authors are not responsible for the results obtained with this program
% This program can be used, modified and shared as long as the authors are
% credited and the program is share under the same conditions
% Please do not delete this header from the file.
%
% uf_ph_man phase 1 line of a 2D maxtrix and apply the phase to the whole
% maxtrix. The phase is set using the uf_ph_man_gui
c = pi/180;
procwaxis = linspace(-0.5,0.5,brukerdata.nZFT);

if exist ([brukerdata.FilePath '/phase_parameters.txt']) == 0
    [~,IndMaxTot] = max(abs(rwdata(:)));
    maxInd = mod(IndMaxTot,size(rwdata,1));
    data_to_ph = rwdata(maxInd,:);
    [phc0,phc1] = uf_ph_man_gui(data_to_ph,brukerdata.nZFT);
    rwdataph = rwdata .*repmat(exp(1i*c*(phc0 + phc1*(procwaxis))),size(rwdata,1),1);
    ph = [phc0 phc1];
    ppfile = fopen([brukerdata.FilePath '/phase_parameters.txt'],'w');
    fprintf(ppfile, '%f %f', ph');
    fclose(ppfile);
else
    ppfile = fopen([brukerdata.FilePath '/phase_parameters.txt'],'r');
    ph = fscanf(ppfile, '%f %f');
    fclose(ppfile);
    phc0 = ph(1);
    phc1 = ph(2);
    rwdataph = rwdata .*repmat(exp(1i*c*(phc0 + phc1*(procwaxis))),size(rwdata,1),1);
    [~,IndMaxTot] = max(abs(rwdataph(:)));
    maxInd = mod(IndMaxTot,size(rwdataph,1));
    data_to_ph = rwdataph(maxInd,:);
%     figure; plot(real(data_to_ph));
    rephase = questdlg('Do you want to rephase ?','Rephase ?','Yes','No','No');
    switch rephase
        case 'Yes'
            [~,IndMaxTot] = max(abs(rwdata(:)));
            maxInd = mod(IndMaxTot,size(rwdata,1));
            data_to_ph = rwdata(maxInd,:);
            [phc0,phc1] = uf_ph_man_gui(data_to_ph,brukerdata.nZFT);
            rwdataph = rwdata .*repmat(exp(1i*c*(phc0 + phc1*(procwaxis))),size(rwdata,1),1);
            ph = [phc0 phc1];
            ppfile = fopen([brukerdata.FilePath '/phase_parameters.txt'],'w');
            fprintf(ppfile, '%f %f', ph');
            fclose(ppfile);
        case 'No'
            
    end
end

end
