function [inputp,brukerdata]=inputpspendosy_GNAT(brukerdata)
%**************************************************************************
%[inputp,brukerdata]=inputpspendosy_GNAT(brukerdata)
% used for providing input parameters to spen2GNAT function. It also
% provides input parameters to spen2GNAT function in brukerimport_SPEN 
%       -Input parameters
%              - brukerdata - in spen2GNAT function, this input is used to 
%                             carry forward the brukerdata structure during
%                             the processing of SPEN DOSY data. It is not
%                             required for the intialisation
%       -Outut parameters
%              - brukerdata - parameters(reference exp no., zero filling
%                             no., baseline correction value, apodization 
%                            function and the region of interest) are saved
%              - inputp - this is only used in brukerimport_SPEN to provide
%                         input parameters to spen_GNAT 
%**************************************************************************

RefPath='220429_BBI_tube39'; 

% defining path for reference profiles /opt/nmrdata/user/nmr/Oksana
inputp.pathexp2 =(['C:\Users\mishra-r\Documents\_UNC\SPEN DOSY\data\Benjamin\' RefPath '/']);
    
% Experiment number for acquisition reference profile 
brukerdata.epsi_refexpno=24;

% Experiment number for chirp+acquisition reference profile
brukerdata.chirp_epsi_refexpno=12;

% defining path for acquisition reference profiles
brukerdata.FilePath_epsi = [inputp.pathexp2 num2str(brukerdata.epsi_refexpno)];

% defining path for chirp+acquisition reference profiles
brukerdata.FilePath_chirp_epsi = [inputp.pathexp2 num2str(brukerdata.chirp_epsi_refexpno)];

% Zero filling in spectroscopic dimension
brukerdata.nZFT=2*1024; 

% Zero filling in imaging dimension
brukerdata.nZFK=2*1024; 

% Window multiplication constant
brukerdata.alpha=0.5;%25/46;%0.46;

% Baseline correction parameter for acquisition reference profiles
brukerdata.NBC_acqref=5; 

% Baseline correction parameter for chirp+acquisition reference profiles
brukerdata.NBC_chirpacqref=5; 

% Apodization constant for 'exp' or 'gaussian' windowed function
brukerdata.apodtime=1;

% Apodization function for k-dimension 
  % Hamming and Hann/Blackman/Nuttall/Blackman-Nuttall/Blackman-Harris
  % Fla-top
brukerdata.apdfunc='Hamming and Hann';

% Apodization function for t-dimension 
  % sin/cos/exp/gaussian/sqsin/sqcos
brukerdata.apdfunc_t='sin';

% Phase mode of the data
  % for magnitude mode data'mc'
  % for phase mode data 'pk'
brukerdata.phmode='mc';

% Choosing the region of fitting for the SPEN data
brukerdata.fitLengthNeg = -0.0050; % negative region
brukerdata.fitLengthPos = 0.0050;  % positive region

% This function is used to pass the information to GNAT.m that the data is
% ultra-fast in nature. It prohibit GNAT.m to do the phase correction which
% is not required for the SPEN DOSY experiment
brukerdata.isuf = 1;


brukerdata.nonuniform_grad_corr='yes';
brukerdata.grad_coeff=[4.4006e-11,9.4624e-10,-4.5281e-09,-1.32999e-07,...
                       -5.09222e-08,5.7893e-06,-6.15755e-06,-1.17046e-4,...
                                  -2.5156e-3,-1.3829e-3,0.750400764331021];




% Base line correction parameter for SPEN data
inputp.NBC_spen=4;

% spen2GNAT function requires the input whether the file to be processed is
% acquisition reference profile or chirp+acquisition reference profile or
% the SPEN DOSY data
    % for acquisition reference profile, inputp.refprof_y_n = 0 
    % for chirp+acquisition reference profile, inputp.refprof_y_n = 1 
    % for SPEN DOSY data, inputp.refprof_y_n = 2 
% in the present case it will always be 2
inputp.refprof_y_n=2;

% correction with acquisition profile
  % 'on'/'off'
inputp.acqref='on';

% correction with acquisition profile
  % 'on'/'off'
inputp.chirpref='off';

% additional smoothing after doing IFT/FT during reference profile
% correction to remove unwanted wiggles from the final spectrum
  % 'yes'/'no'
inputp.add_sm_proc='no';
end