function gammaNuc = nuclist(nuc1)
% This program has been created by  Jean-Nicolas Dumez, Ludmilla Guduff and Corentin Jacquemmoz, 
% CEISAM, CNRS, Universit de Nantes, France
% The authors are not responsible for the results obtained with this program
% This program can be used, modified and shared as long as the authors are
% credited and the program is share under the same conditions
% Please do not delete this header from the file.
% List of gyromagnetic ratio for commonly used nuclei
switch nuc1
    case '<1H>'
        gammaNuc=267524618.573;
    case '<2H>'
        gammaNuc=41066000;
    case '<10B>'
        gammaNuc=28747000;
    case '<11B>'
        gammaNuc=85847000;
    case '<13C>'
        gammaNuc=67283000;
    case '<14N>'
        gammaNuc=19338000;
    case '<15N>'
        gammaNuc=-27126000;
    case '<17O>'
        gammaNuc=-36281000;
    case '<19F>'
        gammaNuc=251815000;
    case '<23Na>'
        gammaNuc=70808000;
    case '<27Al>'
        gammaNuc=69764000;
    case '<29Si>'
        gammaNuc=-53190000;
    case '<31P>'
        gammaNuc=108394000;
        
    otherwise
        disp('unknown nucleus - defaulting to proton')
        gammaNuc=267524618.573;
end

end
